import time,sys,thread

from Numeric import *
from FFT import *

class PowerSpectra:
    def __init__(self,nSpinsX,nSpinsY,nLattice,dt,powerSpectraTime,Jb):
        self.nSpinsX = nSpinsX
        self.nSpinsY = nSpinsY

        self.dt = dt
        self.Jb = Jb
        self.nLattice = nLattice

        self.blue = []

        self.powerSpectraTime = powerSpectraTime

        timestamp = str(time.ctime())
##        self.filename = timestamp + ".log"

        self.logfile = open('test.log', 'w')
        self.logfile.write('\n-----------------------------\n')
        self.logfile.write(timestamp)
        self.logfile.write('\nPower Spectra Started')
        self.logfile.write('\nEnergy at Sites')
        self.logfile.write('\nJb ')
        self.logfile.write(str(self.Jb))
        self.logfile.write('\ndt ')
        self.logfile.write(str(self.dt))
        self.logfile.write('\n\n')
##        self.logfile.write('time\tSpin1\tSpin4\tSpin2\tSpin5\tSpin3\tSpin6\tTotalE')
        self.logfile.write('time\tSpin1\tSpin2\tSpin3\tTotalE')
                                 
        self.logfile.close()

    def SpectraToFile(self, t):
        self.nLattice.getEnergies()

        totalEnergyText = str(self.nLattice.returnTotalEnergy())
        energyArray = resize(self.nLattice.energyArray, (1,self.nSpinsX*self.nSpinsY))

        self.blue.append(energyArray)

        energyText = str(energyArray)[3:-2]
     
        self.logfile = open('test.log','a')

        self.logfile.write('\n')
        self.logfile.write(str(t))
        self.logfile.write('\t')
        self.logfile.write(energyText)
        self.logfile.write('  ')
        self.logfile.write(totalEnergyText)

        self.logfile.close()


    def WriteFFT(self):
##        print self.blue[0:3][0][0]
        FullFFT = fft(self.blue, axis=-1).real
                
        self.logfile = open('test.log','a')
        self.logfile.write('\n\n\n\n')
        self.logfile.write('FFT transforms\n')
        self.logfile.write(str(FullFFT))
        self.logfile.close()



        
